import httpRequest from '@/utils/axios'

/**
 * 获取产品类型列表
 */
export function getCategories(id) {
  return httpRequest.get(`/api/xtraining/api/v1/${id}/categories`).then({})
}

// 获取支付过滤条件
export function getCasesList(id) {
  return httpRequest.get(`/api/xtraining/api/v1/${id}/cases`)
}

// 分配发票跟进人
export function assignSales(data) {
  return httpRequest.post('/api/finance/v1/invoices/assign-sales', data, {})
}

// 发票充值
export function deposit() {
  return httpRequest.post('/api/finance/v1/invoices/deposit')
}

// 下载发票列表
export function downloadInvoices(params) {
  return httpRequest.get('/api/finance/v1/invoices/download', { params, responseType: 'blob' })
}
