// require lib
import Vue from 'vue'
import VueCodemirror from 'vue-codemirror'

// require styles
import 'codemirror/lib/codemirror.css'

// require more codemirror resource...
// import 'codemirror/mode/javascript/javascript'
// import 'codemirror/mode/css/css'
// import 'codemirror/mode/xml/xml'
import 'codemirror/mode/python/python.js'
import 'codemirror/mode/htmlmixed/htmlmixed'
import 'codemirror/mode/markdown/markdown'

// 代码折叠
import 'codemirror/addon/fold/foldgutter.css'
import 'codemirror/addon/fold/foldcode'
import 'codemirror/addon/fold/foldgutter'
import 'codemirror/addon/fold/brace-fold'
import 'codemirror/addon/fold/xml-fold'
import 'codemirror/addon/fold/indent-fold'
import 'codemirror/addon/fold/markdown-fold'
import 'codemirror/addon/fold/comment-fold'

// 代码自动补全
import 'codemirror/addon/hint/show-hint.css'
import 'codemirror/addon/hint/show-hint'
import 'codemirror/addon/hint/javascript-hint'
import 'codemirror/addon/hint/css-hint'
import 'codemirror/addon/hint/html-hint'

// 高亮行
import 'codemirror/addon/selection/active-line'

// 括号配对
import 'codemirror/addon/edit/matchbrackets'

// you can set default global options and events when use
Vue.use(VueCodemirror, {
  options: {
    mode: 'python',
    tabSize: 2, // 缩进
    smartIndent: true, // 智能缩进
    indentUnit: 2, // 智能缩进单位为4个空格长度
    indentWithTabs: true, // 使用制表符进行智能缩进
    lineNumbers: true, // 行号
    lineWrapping: false, // 换行
    foldGutter: true, // 折叠
    gutters: ['CodeMirror-linenumbers', 'CodeMirror-foldgutter'], // 折叠
    matchBrackets: true, // 括号配对
    autoCloseBrackets: true, // 自动闭合符号
    styleActiveLine: true, // 高亮行
    extraKeys: { Ctrl: 'autocomplete' } // 快捷键代码自动补全
  }
})
Vue.use(VueCodemirror)
