import httpRequest from '@/utils/axios'

/**
 * 获取产品类型列表
 */
export function getCategories(id) {
  return httpRequest.get(`/api/xtraining/api/v1/${id}/categories`).then({})
}

// 获取案例列表
export function getCasesList(id) {
  return httpRequest.get(`/api/xtraining/api/v1/${id}/cases`)
}

// 选中案例
export function selectCase(id) {
  return httpRequest.post(`/api/xtraining/api/v1/${id}/select-case`, {})
}

// 获取产品分析填空题
export function caseCompletions(id) {
  return httpRequest.get(`/api/xtraining/api/v1/${id}/case-completions`, {})
}

// 提交案例（产品）分析报告
export function commitCase(data) {
  return httpRequest.post('/api/xtraining/api/v1/commit-case', data, {
    headers: { 'Content-Type': 'application/json' }
  })
}

// // 获取案例（产品）分析结答题结果
// export function getCommitCase() {
//   return httpRequest.get('/api/xtraining/api/v1/commit-case-detail', {})
// }

// 获取案例（产品）分析结答题结果
export function getCommitCase(id) {
  return httpRequest.get(`/api/xtraining/api/v1/answer/${id}/case-report`, {})
}

// 产品分析保存答案
export function cacheCaseAnswer(id, data) {
  return httpRequest.post(`/api/xtraining/api/v1/answer/${id}/save-case-record`, data, {
    headers: { 'Content-Type': 'application/json' }
  })
}
